/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import com.bxm.newidea.component.constant.LocationConstant;

public class GouldUtils {
    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lng1, double lat1, double lng2, double lat2) {
        double radLat1 = GouldUtils.rad(lat1);
        double radLat2 = GouldUtils.rad(lat2);
        double a = radLat1 - radLat2;
        double b = GouldUtils.rad(lng1) - GouldUtils.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= LocationConstant.EARTH_RADIUS;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s *= 1000.0;
    }

    public static boolean isWithinTheScopeOf(double lng, double lat, double lng2, double lat2, Long radius) {
        double distance1 = GouldUtils.getDistance(lng, lat, lng2, lat2);
        double distance2 = GouldUtils.getDistance(lng, lat, lng2, lat2);
        double distance3 = GouldUtils.getDistance(lng, lat, lng2, lat2);
        return distance1 <= (double)radius.longValue() || distance2 <= (double)radius.longValue() || distance3 <= (double)radius.longValue();
    }

    public static boolean isInArea(Double latitude, Double lngitude, Double areaLatitude1, Double areaLatitude2, Double areaLongitude1, Double areaLongitude2) {
        if (GouldUtils.isInRange(latitude, areaLatitude1, areaLatitude2)) {
            if (areaLongitude1 * areaLongitude2 > 0.0) {
                return GouldUtils.isInRange(lngitude, areaLongitude1, areaLongitude2);
            }
            if (Math.abs(areaLongitude1) + Math.abs(areaLongitude2) < 180.0) {
                return GouldUtils.isInRange(lngitude, areaLongitude1, areaLongitude2);
            }
            double left = Math.max(areaLongitude1, areaLongitude2);
            double right = Math.min(areaLongitude1, areaLongitude2);
            return GouldUtils.isInRange(lngitude, left, 180.0) || GouldUtils.isInRange(lngitude, right, -180.0);
        }
        return false;
    }

    private static boolean isInRange(Double point, Double left, Double right) {
        return point >= Math.min(left, right) && point <= Math.max(left, right);
    }
}

