/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.httpclient.service;

import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OKHttpService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(OKHttpService.class);

    public String get(String url, Map<String, String> headerMap) {
        return this.extractResponse(new Request.Builder().url(url).get(), headerMap);
    }

    private String extractResponse(Request.Builder requestBuilder, Map<String, String> headerMap) {
        try {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                requestBuilder.addHeader(entry.getKey(), entry.getValue());
            }
            OkHttpClient client = new OkHttpClient();
            Request request = requestBuilder.build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                return Objects.requireNonNull(response.body()).string();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String get(String url, Map<String, String> params, Map<String, String> headerMap) {
        Request.Builder request = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            request = new Request.Builder().url(uriBuilder.toString()).get();
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.extractResponse(request, headerMap);
    }

    public String postForm(String url, Map<String, String> params, Map<String, String> headerMap) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        Request.Builder request = new Request.Builder().url(url).post((RequestBody)builder.build());
        return this.extractResponse(request, headerMap);
    }

    public String postPlainBody(String url, String content, Map<String, String> headerMap) {
        Request.Builder request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)String.valueOf(ContentType.TEXT_PLAIN)), (String)content));
        return this.extractResponse(request, headerMap);
    }

    public String postJsonBody(String url, String content, Map<String, String> headerMap) {
        Request.Builder request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)String.valueOf(ContentType.APPLICATION_JSON)), (String)content));
        return this.extractResponse(request, headerMap);
    }

    public void download(String url, String filePath) {
        Request request = new Request.Builder().url(url).build();
        OkHttpClient client = new OkHttpClient();
        try {
            Response response = client.newCall(request).execute();
            this.saveFile(response, url, filePath);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(Response response, String url, String filePath) {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            if (response.body() == null) {
                log.error("URL\uff1a{}\u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728", (Object)url);
                return;
            }
            byte[] buf = new byte[2048];
            is = response.body().byteStream();
            File file = new File(filePath);
            FileUtils.checkAndCreateFile((File)file);
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.flush();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void downloadAysn(final String url, final String filePath) {
        Request request = new Request.Builder().url(url).build();
        OkHttpClient client = new OkHttpClient();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)url);
                log.error(e.getMessage(), (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                OKHttpService.this.saveFile(response, url, filePath);
            }
        });
    }
}

