/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.httpclient.service;

import com.bxm.newidea.component.service.BaseService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.springframework.stereotype.Service;

@Service
public class OKHttpService
extends BaseService {
    public String get(String url, Map<String, String> headerMap) {
        return this.extractResponse(new Request.Builder().url(url).get(), headerMap);
    }

    private String extractResponse(Request.Builder requestBuilder, Map<String, String> headerMap) {
        try {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                requestBuilder.addHeader(entry.getKey(), entry.getValue());
            }
            OkHttpClient client = new OkHttpClient();
            Request request = requestBuilder.build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                return Objects.requireNonNull(response.body()).string();
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String get(String url, Map<String, String> params, Map<String, String> headerMap) {
        Request.Builder request = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            request = new Request.Builder().url(uriBuilder.toString()).get();
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return this.extractResponse(request, headerMap);
    }

    public String postForm(String url, Map<String, String> params, Map<String, String> headerMap) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        Request.Builder request = new Request.Builder().url(url).post((RequestBody)builder.build());
        return this.extractResponse(request, headerMap);
    }

    public String postPlainBody(String url, String content, Map<String, String> headerMap) {
        Request.Builder request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)String.valueOf(ContentType.TEXT_PLAIN)), (String)content));
        return this.extractResponse(request, headerMap);
    }

    public String postJsonBody(String url, String content, Map<String, String> headerMap) {
        Request.Builder request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)String.valueOf(ContentType.APPLICATION_JSON)), (String)content));
        return this.extractResponse(request, headerMap);
    }
}

