package com.huawei.push.javasdk.messaging;

/**
 * the services exposed from the HCM SDK
 * Each instance of the class is associated with one instance of the HuaweiApp
 */
public abstract class HuaweiService<T> {
    private String id;
    protected T instance;

    protected HuaweiService(String id, T instance) {
        this.id = id;
        this.instance = instance;
    }

    public String getId() {
        return id;
    }

    public T getInstance() {
        return instance;
    }

    public abstract void destroy();
}
