/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.javasdk.message;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.javasdk.message.BadgeNotification;
import com.huawei.push.javasdk.message.ClickAction;
import com.huawei.push.javasdk.message.Notification;
import com.huawei.push.javasdk.util.CollectionUtils;
import com.huawei.push.javasdk.util.ValidatorUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AndroidNotification {
    private static final String COLOR_PATTERN = "^#[0-9a-fA-F]{6}$";
    private static final String URL_PATTERN = "^https.*";
    @JSONField(name="title")
    private String title;
    @JSONField(name="body")
    private String body;
    @JSONField(name="icon")
    private String icon;
    @JSONField(name="color")
    private String color;
    @JSONField(name="sound")
    private String sound;
    @JSONField(name="tag")
    private String tag;
    @JSONField(name="click_action")
    private ClickAction clickAction;
    @JSONField(name="body_loc_key")
    private String bodyLocKey;
    @JSONField(name="body_loc_args")
    private List<String> bodyLocArgs = new ArrayList<String>();
    @JSONField(name="title_loc_key")
    private String titleLocKey;
    @JSONField(name="title_loc_args")
    private List<String> titleLocArgs = new ArrayList<String>();
    @JSONField(name="channel_id")
    private String channelId;
    @JSONField(name="notify_summary")
    private String notifySummary;
    @JSONField(name="notify_icon")
    private String notifyIcon;
    @JSONField(name="style")
    private Integer style;
    @JSONField(name="big_title")
    private String bigTitle;
    @JSONField(name="big_body")
    private String bigBody;
    @JSONField(name="big_picture")
    private String bigPicture;
    @JSONField(name="auto_clear")
    private Integer autoClear;
    @JSONField(name="notify_id")
    private Integer notifyId;
    @JSONField(name="group")
    private String group;
    @JSONField(name="badge")
    private BadgeNotification badge;

    private AndroidNotification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.icon = builder.icon;
        this.color = builder.color;
        this.sound = builder.sound;
        this.tag = builder.tag;
        this.clickAction = builder.clickAction;
        this.bodyLocKey = builder.bodyLocKey;
        if (!CollectionUtils.isEmpty(builder.bodyLocArgs)) {
            this.bodyLocArgs.addAll(builder.bodyLocArgs);
        } else {
            this.bodyLocArgs = null;
        }
        this.titleLocKey = builder.titleLocKey;
        if (!CollectionUtils.isEmpty(builder.titleLocArgs)) {
            this.titleLocArgs.addAll(builder.titleLocArgs);
        } else {
            this.titleLocArgs = null;
        }
        this.channelId = builder.channelId;
        this.notifySummary = builder.notifySummary;
        this.notifyIcon = builder.notifyIcon;
        this.style = builder.style;
        this.bigTitle = builder.bigTitle;
        this.bigBody = builder.bigBody;
        this.bigPicture = builder.bigPicture;
        this.autoClear = builder.autoClear;
        this.notifyId = builder.notifyId;
        this.group = builder.group;
        this.badge = null != builder.badge ? builder.badge : null;
    }

    public void check(Notification notification) {
        if (null != notification) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)notification.getTitle()) || StringUtils.isNotEmpty((CharSequence)this.title), "title should be set");
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)notification.getBody()) || StringUtils.isNotEmpty((CharSequence)this.body), "body should be set");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.color)) {
            ValidatorUtils.checkArgument(this.color.matches(COLOR_PATTERN), "Wrong color format, color must be in the form #RRGGBB");
        }
        if (!CollectionUtils.isEmpty(this.bodyLocArgs)) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.bodyLocKey), "bodyLocKey is required when specifying bodyLocArgs");
        }
        if (!CollectionUtils.isEmpty(this.titleLocArgs)) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.titleLocKey), "titleLocKey is required when specifying titleLocArgs");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.notifyIcon)) {
            ValidatorUtils.checkArgument(this.notifyIcon.matches(URL_PATTERN), "notifyIcon must start with https");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.bigPicture)) {
            ValidatorUtils.checkArgument(this.bigPicture.matches(URL_PATTERN), "notifyIcon must start with https");
        }
        if (this.style != null) {
            boolean isTrue = this.style == 0 || this.style == 1 || this.style == 2;
            ValidatorUtils.checkArgument(isTrue, "style should be one of 0:default, 1: big text, 2: big picture");
            if (this.style == 1) {
                ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.bigTitle) && StringUtils.isNotEmpty((CharSequence)this.bigBody), "title and body are required when style = 1");
            }
            if (this.style == 2) {
                ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.bigPicture), "picture is required when style = 2");
            }
        }
        if (this.clickAction != null) {
            this.clickAction.check();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public String getSound() {
        return this.sound;
    }

    public String getTag() {
        return this.tag;
    }

    public ClickAction getClickAction() {
        return this.clickAction;
    }

    public String getBodyLocKey() {
        return this.bodyLocKey;
    }

    public List<String> getBodyLocArgs() {
        return this.bodyLocArgs;
    }

    public String getTitleLocKey() {
        return this.titleLocKey;
    }

    public List<String> getTitleLocArgs() {
        return this.titleLocArgs;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getNotifySummary() {
        return this.notifySummary;
    }

    public String getNotifyIcon() {
        return this.notifyIcon;
    }

    public Integer getStyle() {
        return this.style;
    }

    public String getBigTitle() {
        return this.bigTitle;
    }

    public String getBigBody() {
        return this.bigBody;
    }

    public String getBigPicture() {
        return this.bigPicture;
    }

    public Integer getAutoClear() {
        return this.autoClear;
    }

    public Integer getNotifyId() {
        return this.notifyId;
    }

    public String getGroup() {
        return this.group;
    }

    public BadgeNotification getBadge() {
        return this.badge;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String icon;
        private String color;
        private String sound;
        private String tag;
        private ClickAction clickAction;
        private String bodyLocKey;
        private List<String> bodyLocArgs = new ArrayList<String>();
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private String channelId;
        private String notifySummary;
        private String notifyIcon;
        private Integer style;
        private String bigTitle;
        private String bigBody;
        private String bigPicture;
        private Integer autoClear;
        private Integer notifyId;
        private String group;
        private BadgeNotification badge;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setColor(String color) {
            this.color = color;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setClickAction(ClickAction clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public Builder setBodyLocKey(String bodyLocKey) {
            this.bodyLocKey = bodyLocKey;
            return this;
        }

        public Builder addBodyLocArgs(String arg) {
            this.bodyLocArgs.add(arg);
            return this;
        }

        public Builder addAllBodyLocArgs(List<String> args) {
            this.bodyLocArgs.addAll(args);
            return this;
        }

        public Builder setTitleLocKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public Builder addTitleLocArgs(String arg) {
            this.titleLocArgs.add(arg);
            return this;
        }

        public Builder addAllTitleLocArgs(List<String> args) {
            this.titleLocArgs.addAll(args);
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setNotifySummary(String notifySummary) {
            this.notifySummary = notifySummary;
            return this;
        }

        public Builder setNotifyIcon(String notifyIcon) {
            this.notifyIcon = notifyIcon;
            return this;
        }

        public Builder setStyle(Integer style) {
            this.style = style;
            return this;
        }

        public Builder setBigTitle(String bigTitle) {
            this.bigTitle = bigTitle;
            return this;
        }

        public Builder setBigBody(String bigBody) {
            this.bigBody = bigBody;
            return this;
        }

        public Builder setBigPicture(String bigPicture) {
            this.bigPicture = bigPicture;
            return this;
        }

        public Builder setAutoClear(Integer autoClear) {
            this.autoClear = autoClear;
            return this;
        }

        public Builder setNotifyId(Integer notifyId) {
            this.notifyId = notifyId;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setBadge(BadgeNotification badge) {
            this.badge = badge;
            return this;
        }

        public AndroidNotification build() {
            return new AndroidNotification(this);
        }
    }
}

