package com.huawei.push.javasdk.messaging;

import com.huawei.push.javasdk.exception.HuaweiMesssagingException;
import com.huawei.push.javasdk.message.Message;

/**
 * An interface for sending Huawei Cloud Messaging (HCM) messages.
 */
public interface HuaweiMessageClient {

    /**
     * Sends the given message with HCM.
     * @param message      A non-null {@link Message} to be sent.
     * @param validateOnly A boolean indicating whether to perform a validation only of the send.
     * @return {@link SendResponse}.
     * @throws HuaweiMesssagingException If an error occurs while handing the message off to HCM for
     *                                   delivery.
     */
    SendResponse send(Message message, boolean validateOnly, String accessToken) throws HuaweiMesssagingException;

}
