/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.javasdk.message;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.Strings;
import com.google.common.primitives.Booleans;
import com.huawei.push.javasdk.message.AndroidConfig;
import com.huawei.push.javasdk.message.Notification;
import com.huawei.push.javasdk.util.CollectionUtils;
import com.huawei.push.javasdk.util.ValidatorUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Message {
    @JSONField(name="data")
    private String data;
    @JSONField(name="notification")
    private Notification notification;
    @JSONField(name="android")
    private AndroidConfig androidConfig;
    @JSONField(name="token")
    private List<String> token = new ArrayList<String>();
    @JSONField(name="topic")
    private String topic;
    @JSONField(name="condition")
    private String condition;

    private Message(Builder builder) {
        this.data = builder.data;
        this.notification = builder.notification;
        this.androidConfig = builder.androidConfig;
        if (!CollectionUtils.isEmpty(builder.token)) {
            this.token.addAll(builder.token);
        } else {
            this.token = null;
        }
        this.topic = builder.topic;
        this.condition = builder.condition;
        this.check();
    }

    public void check() {
        int count = Booleans.countTrue((boolean[])new boolean[]{!CollectionUtils.isEmpty(this.token), !Strings.isNullOrEmpty((String)this.topic), !Strings.isNullOrEmpty((String)this.condition)});
        ValidatorUtils.checkArgument(count == 1, "Exactly one of token, topic or condition must be specified");
        boolean isEmptyData = StringUtils.isEmpty((CharSequence)this.data);
        if (null != this.androidConfig) {
            this.androidConfig.check(this.notification);
        }
    }

    public String getData() {
        return this.data;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public AndroidConfig getAndroidConfig() {
        return this.androidConfig;
    }

    public List<String> getToken() {
        return this.token;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getCondition() {
        return this.condition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String data;
        private Notification notification;
        private AndroidConfig androidConfig;
        private List<String> token = new ArrayList<String>();
        private String topic;
        private String condition;

        private Builder() {
        }

        public Builder setData(String data) {
            this.data = data;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setAndroidConfig(AndroidConfig androidConfig) {
            this.androidConfig = androidConfig;
            return this;
        }

        public Builder addToken(String token) {
            this.token.add(token);
            return this;
        }

        public Builder addAllToken(List<String> tokens) {
            this.token.addAll(tokens);
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setCondition(String condition) {
            this.condition = condition;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

