/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.javasdk.messaging;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.JSONObject;
import com.huawei.push.javasdk.exception.HuaweiMesssagingException;
import com.huawei.push.javasdk.message.Message;
import com.huawei.push.javasdk.messaging.HuaweiApp;
import com.huawei.push.javasdk.messaging.HuaweiMessageClient;
import com.huawei.push.javasdk.messaging.ImplHuaweiTrampolines;
import com.huawei.push.javasdk.messaging.SendResponse;
import com.huawei.push.javasdk.util.ResponceCodeProcesser;
import com.huawei.push.javasdk.util.ValidatorUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HuaweiMessageClientImpl
implements HuaweiMessageClient {
    private static final String HCM_SEND_URL = ResourceBundle.getBundle("url").getString("HCM_SEND_URL");
    private final String HcmSendUrl;
    private final CloseableHttpClient httpClient;

    private HuaweiMessageClientImpl(Builder builder) {
        this.HcmSendUrl = MessageFormat.format(HCM_SEND_URL, builder.appId);
        ValidatorUtils.checkArgument(builder.httpClient != null, "requestFactory must not be null");
        this.httpClient = builder.httpClient;
    }

    public String getHcmSendUrl() {
        return this.HcmSendUrl;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public SendResponse send(Message message, boolean validateOnly, String accessToken) throws HuaweiMesssagingException {
        try {
            return this.sendRequest(message, validateOnly, accessToken);
        }
        catch (IOException e) {
            throw new HuaweiMesssagingException("internal error", "Error while calling HCM backend service", e);
        }
    }

    private SendResponse sendRequest(Message message, boolean validateOnly, String accessToken) throws IOException, HuaweiMesssagingException {
        Map<String, Object> map = this.createRequestMap(message, validateOnly);
        HttpPost httpPost = new HttpPost(this.HcmSendUrl);
        StringEntity entity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        httpPost.setHeader("Authorization", "Bearer " + accessToken);
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        String rpsContent = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            JSONObject jsonObject = JSONObject.parseObject((String)rpsContent);
            Integer code = jsonObject.getInteger("code");
            String msg = jsonObject.getString("msg");
            String requestId = jsonObject.getString("requestId");
            if (code == 80000000) {
                return SendResponse.fromCode(code, ResponceCodeProcesser.process(code), requestId);
            }
            String errorMsg = MessageFormat.format("error code : {0}, error message : {1}", String.valueOf(code), ResponceCodeProcesser.process(code));
            throw new HuaweiMesssagingException("known error", errorMsg);
        }
        HttpResponseException exception = new HttpResponseException(statusCode, rpsContent);
        throw this.createExceptionFromResponse(exception);
    }

    private Map<String, Object> createRequestMap(final Message message, final boolean validateOnly) {
        return new HashMap<String, Object>(){
            {
                this.put("validation_only", validateOnly);
                this.put("message", message);
            }
        };
    }

    private HuaweiMesssagingException createExceptionFromResponse(HttpResponseException e) {
        String msg = MessageFormat.format("Unexpected HTTP response with status : {0}, body : {1}", e.getStatusCode(), e.getMessage());
        return new HuaweiMesssagingException("unknown error", msg, (Throwable)e);
    }

    static HuaweiMessageClientImpl fromApp(HuaweiApp app) {
        String appId = ImplHuaweiTrampolines.getAppId(app);
        return HuaweiMessageClientImpl.builder().setAppId(appId).setHttpClient(app.getOption().getHttpClient()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String appId;
        private CloseableHttpClient httpClient;

        private Builder() {
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setHttpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public HuaweiMessageClientImpl build() {
            return new HuaweiMessageClientImpl(this);
        }
    }
}

