/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.jwt.tools;

import com.bxm.newidea.component.jwt.constant.JwtContant;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JwtTokenUtil {
    private JwtTokenUtil() {
    }

    public static String parseToken(String token) {
        String username;
        try {
            Claims claims = JwtTokenUtil.getClaimsFromToken(token);
            username = claims.getSubject();
        }
        catch (Exception e) {
            username = null;
        }
        return username;
    }

    private static Date getCreatedDateFromToken(String token) {
        Date created;
        try {
            Claims claims = JwtTokenUtil.getClaimsFromToken(token);
            created = new Date((Long)claims.get((Object)"created"));
        }
        catch (Exception e) {
            created = null;
        }
        return created;
    }

    private static Date getExpirationDateFromToken(String token) {
        Date expiration;
        try {
            Claims claims = JwtTokenUtil.getClaimsFromToken(token);
            expiration = claims.getExpiration();
        }
        catch (Exception e) {
            expiration = null;
        }
        return expiration;
    }

    public static Claims getClaimsFromToken(String token) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(JwtContant.TOKEN_SECRET).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    private static Boolean isCreatedBeforeLastPasswordReset(Date created, Date lastPasswordReset) {
        return lastPasswordReset != null && created.before(lastPasswordReset);
    }

    public static String generateToken(Long userId) {
        return JwtTokenUtil.generateToken(userId, null);
    }

    public static String generateToken(Long userId, String authCombineCode) {
        HashMap claims = Maps.newHashMap();
        claims.put("sub", userId);
        claims.put("created", new Date());
        if (null != authCombineCode) {
            claims.put("acc", authCombineCode);
        }
        return JwtTokenUtil.generateToken(claims);
    }

    private static String generateToken(Map<String, Object> claims) {
        return Jwts.builder().setClaims(claims).setExpiration(JwtTokenUtil.generateExpirationDate()).signWith(SignatureAlgorithm.HS512, JwtContant.TOKEN_SECRET).compact();
    }

    public static Boolean canTokenBeRefreshed(String token, Date lastReset) {
        Date created = JwtTokenUtil.getCreatedDateFromToken(token);
        return JwtTokenUtil.isCreatedBeforeLastPasswordReset(created, lastReset) == false && JwtTokenUtil.isTokenExpired(token) == false;
    }

    public static String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = JwtTokenUtil.getClaimsFromToken(token);
            claims.put((Object)"created", (Object)new Date());
            refreshedToken = JwtTokenUtil.generateToken((Map<String, Object>)claims);
        }
        catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }

    private static Boolean isTokenExpired(String token) {
        Date expiration = JwtTokenUtil.getExpirationDateFromToken(token);
        return expiration.before(new Date());
    }

    public static Date generateExpirationDate() {
        long expiration = 6220800000L;
        return new Date(System.currentTimeMillis() + expiration);
    }
}

