package com.bxm.component.jwt.util;

import com.bxm.component.jwt.bo.JwtTokenBO;
import com.bxm.component.jwt.builder.TokenBuildParam;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import lombok.extern.slf4j.Slf4j;

/**
 * @author liujia
 * @date 6/2/21 7:10 PM
 **/
@Slf4j
public class JwtUtil {

    private JwtUtil() {
    }

    /**
     * 创建一个token
     *
     * @param buildParam 构建token的参数
     * @return token值
     */
    public static String generateToken(TokenBuildParam buildParam) {
        return Jwts.builder()
                .setHeader(buildParam.getHeaderMap())
                .setClaims(buildParam.getClaimMap())
                .setExpiration(buildParam.getExpirationTime())
                .setIssuedAt(buildParam.getIssueDate())
                .signWith(buildParam.getSignatureAlgorithm(), buildParam.getSignatureKey())
                .compact();
    }

    /**
     * 解析token
     *
     * @param token        token字符串
     * @param signatureKey token对应的加密字符串
     * @return 解密结果
     */
    public static JwtTokenBO parseToken(String token, String signatureKey) {
        Jwt jwt = Jwts.parser()
                .setSigningKey(signatureKey)
                .parse(token);

        JwtTokenBO tokenBO = new JwtTokenBO();

        Object body = jwt.getBody();
        if (body instanceof Claims) {
            tokenBO.setBody((Claims) body);
        }

        tokenBO.setHeader(jwt.getHeader());

        return tokenBO;
    }
}
