/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.jwt.builder;

import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TokenBuildParam {
    private Map<String, Object> headerMap = new HashMap<String, Object>();
    private Map<String, Object> claimMap = new HashMap<String, Object>();
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
    private String signatureKey;
    private Date expirationTime;
    private Date issueDate;

    public static TokenBuildParam create() {
        return new TokenBuildParam();
    }

    public Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public TokenBuildParam setHeaderMap(Map<String, Object> headerMap) {
        this.headerMap = headerMap;
        return this;
    }

    public TokenBuildParam putHeader(String key, Object value) {
        this.headerMap.put(key, value);
        return this;
    }

    public Map<String, Object> getClaimMap() {
        return this.claimMap;
    }

    public TokenBuildParam putClaim(String key, String value) {
        this.claimMap.put(key, value);
        return this;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public TokenBuildParam setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public String getSignatureKey() {
        return this.signatureKey;
    }

    public TokenBuildParam setSignatureKey(String signatureKey) {
        this.signatureKey = signatureKey;
        return this;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public TokenBuildParam setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public TokenBuildParam setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }
}

