/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mybatis.dbshunt.strategy.handle;

import com.bxm.component.mybatis.dbshunt.emtity.ShuntTableLog;
import com.bxm.component.mybatis.dbshunt.enums.DBShuntTypeEnum;
import com.bxm.component.mybatis.dbshunt.param.ShuntParam;
import com.bxm.component.mybatis.dbshunt.strategy.handle.AbstractTableHandler;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitTableNameByYearHandle
extends AbstractTableHandler {
    private static final Logger log = LoggerFactory.getLogger(InitTableNameByYearHandle.class);
    @Autowired
    private SequenceCreater sequenceCreater;
    public static final String DATE_YEAR_FORMAT = "yyyy";
    public static ThreadLocal<DateFormat> PATTERN_YEAR_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_YEAR_FORMAT));

    @Override
    public void tableDataHandler(ShuntParam shuntParam) {
        this.initShuntTableData(shuntParam.getDataName());
        ShuntTableLog shuntTableLog = this.getLastLogByTableNameAndType(shuntParam.getTableName(), shuntParam.getDbShuntTypeEnum());
        shuntTableLog = shuntTableLog == null ? this.insertTableLog(shuntParam) : this.judgeTableLogInfoExpire(shuntTableLog, shuntParam);
        this.finalHandlerData(shuntTableLog, shuntParam);
    }

    private void finalHandlerData(ShuntTableLog shuntTableLog, ShuntParam shuntParam) {
        List<String> tableNameList = this.getTableNameList(shuntParam.getDataName(), shuntParam.getTableName());
        if (tableNameList.isEmpty()) {
            log.error("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728");
            return;
        }
        String newTableName = shuntTableLog.getTableName() + "_" + shuntTableLog.getType() + "_" + shuntTableLog.getSuffix();
        String dateStr = shuntTableLog.getSuffix() + "-12-31 23:59:59";
        this.initNewNameTable(newTableName, shuntParam);
        boolean isHandler = false;
        if (tableNameList.size() > 1) {
            Pattern pattern = Pattern.compile(shuntParam.getTableName() + "_[\\d]{1,}$");
            for (String tableName : tableNameList) {
                Matcher matcher = pattern.matcher(tableName);
                if (!matcher.find()) continue;
                this.insertAndDelData(tableName, newTableName, shuntParam.getConditionField(), dateStr);
                isHandler = true;
            }
        } else {
            this.insertAndDelData(tableNameList.get(0), newTableName, shuntParam.getConditionField(), dateStr);
            isHandler = true;
        }
        if (!isHandler) {
            this.insertAndDelData(tableNameList.get(0), newTableName, shuntParam.getConditionField(), dateStr);
        }
    }

    private void insertAndDelData(String oldTableName, String newTableName, String conditionField, String dateStr) {
        int existDataByDate;
        while ((existDataByDate = this.dbShuntMapper.isExistDataByDate(oldTableName, conditionField, dateStr)) != 0) {
            this.dbShuntMapper.insertDataToNewTable(newTableName, oldTableName, conditionField, dateStr);
            this.dbShuntMapper.deleteOldTableData(oldTableName, conditionField, dateStr);
        }
    }

    private ShuntTableLog insertTableLog(ShuntParam shuntParam) {
        ShuntTableLog shuntTableLog = new ShuntTableLog();
        shuntTableLog.setId(this.sequenceCreater.nextLongId());
        shuntTableLog.setCreateTime(new Date());
        shuntTableLog.setSuffix(InitTableNameByYearHandle.tableSuffixHandler());
        shuntTableLog.setTableName(shuntParam.getTableName());
        shuntTableLog.setType(shuntParam.getDbShuntTypeEnum().getType());
        shuntTableLog.setTypeValue(shuntParam.getTypeValue());
        this.dbShuntMapper.insertTableNameLog("t_db_shunt_table_log", shuntTableLog);
        return shuntTableLog;
    }

    private static String tableSuffixHandler() {
        Date date = DateUtils.addYears((Date)new Date(), (int)-1);
        return PATTERN_YEAR_FORMAT.get().format(date);
    }

    private ShuntTableLog judgeTableLogInfoExpire(ShuntTableLog shuntTableLog, ShuntParam shuntParam) {
        Date date1;
        Date date = DateUtils.setYears((Date)new Date(), (int)Integer.parseInt(shuntTableLog.getSuffix()));
        boolean sameDay = DateUtils.isSameDay((Date)date, (Date)(date1 = DateUtils.addYears((Date)new Date(), (int)-1)));
        if (!sameDay) {
            return this.insertTableLog(shuntParam);
        }
        return shuntTableLog;
    }

    @Override
    public DBShuntTypeEnum getType() {
        return DBShuntTypeEnum.YEAR;
    }
}

