/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mybatis.utils;

import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class BatchHelper<T, E> {
    protected T mapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private short limit = (short)500;
    private SqlSessionTemplate sqlSessionTemplate;
    private String sqlSessionTemplateName;
    private Collection<E> data;
    private Class<T> mapperClass;
    private int total;
    private boolean strict;

    public BatchHelper(Class<T> mapperClass, Collection<E> data) {
        this.mapperClass = mapperClass;
        this.data = data;
        if (!CollectionUtils.isEmpty(data)) {
            this.doBatch();
        }
    }

    public BatchHelper(Class<T> mapperClass, E[] data) {
        this.mapperClass = mapperClass;
        this.data = ImmutableList.copyOf((Object[])data).asList();
        if (!CollectionUtils.isEmpty(this.data)) {
            this.doBatch();
        }
    }

    protected void setLimit(short limit) {
        this.limit = limit;
    }

    protected void setStrict(boolean strict) {
        this.strict = strict;
    }

    public final boolean success() {
        if (this.strict) {
            return this.data != null && this.total == this.data.size();
        }
        return this.total != 0;
    }

    public void setSqlSessionTemplateName(String sqlSessionTemplateName) {
        this.sqlSessionTemplateName = sqlSessionTemplateName;
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    private void initTemplate() {
        if (this.sqlSessionTemplate == null) {
            this.sqlSessionTemplate = null != this.sqlSessionTemplateName ? (SqlSessionTemplate)SpringContextHolder.getBean((String)this.sqlSessionTemplateName) : (SqlSessionTemplate)SpringContextHolder.getBean(SqlSessionTemplate.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatch() {
        this.initTemplate();
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH);
        this.mapper = session.getMapper(this.mapperClass);
        try {
            int i = 1;
            for (E element : this.data) {
                this.total += this.invoke(element);
                if (i % this.limit == 0) {
                    session.commit();
                    session.clearCache();
                }
                ++i;
            }
        }
        catch (Exception e) {
            session.rollback();
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.data.size() % this.limit != 0) {
                session.commit();
                session.clearCache();
            }
            session.close();
        }
    }

    protected abstract int invoke(E var1);
}

