package com.bxm.handler;

/**
 * nacos配置变更后的处理接口
 *
 * @author lowi
 * @date 2022/3/4 11:08
 */

public interface NacosConfigChangeHandler<T> {

    /**
     * 配置变更后的逻辑处理
     *
     * @param before 变更之前的配置值
     * @param after  变更之后的配置值
     */
    default void change(String key, T before, T after) {

    }

    /**
     * 删除数据处理
     */
    default void remove(String key) {

    }

    /**
     * 监听变更的配置的键值，默认会标准化为驼峰命名格式
     * 支持前缀匹配
     *
     * @return {@link String} 监听的键值
     */
    String listenerConfigKey();

}
