package com.bxm.component.httpclient.service;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * okhttp的spring注入类
 * 兼容历史代码，保留此类
 * @deprecated 需要spring环境，过于重，推荐使用{@link com.bxm.component.httpclient.utils.OkHttpUtils}
 */
@Service
@Slf4j
public class OKHttpService {

    /**
     * 发起get请求
     * @param url 请求地址
     * @return 响应结果
     */
    public String get(String url) {
        return OkHttpUtils.get(url);
    }

    /**
     * 发起get请求
     * @param url       请求地址
     * @param headerMap head
     * @return 响应结果
     */
    public String get(String url, Map<String, String> headerMap) {
        return OkHttpUtils.get(url, headerMap);
    }

    /**
     * 发起get请求 默认header
     * @param url    url
     * @param params params
     * @return 响应结果
     */
    public String getWithDefaultHeader(String url, Map<String, ?> params) {
        return OkHttpUtils.getWithDefaultHeader(url, params);
    }

    /**
     * 发起get请求
     * @param url       url
     * @param params    params
     * @param headerMap header
     * @return 响应结果
     */
    public String get(String url, Map<String, ?> params, Map<String, String> headerMap) {
        return OkHttpUtils.get(url, params, headerMap);
    }

    /**
     * post提交form表单
     * @param url    提交地址
     * @param params 表单参数KV
     * @return 响应结果
     */
    public String postForm(String url, Map<String, ?> params, Map<String, String> headerMap) {
        return OkHttpUtils.postForm(url, params, headerMap);
    }

    /**
     * 提交空白的body post请求
     * @param url     请求地址
     * @param content 请求body内容
     * @return 响应结果
     */
    public String postPlainBody(String url, String content, Map<String, String> headerMap) {
        return OkHttpUtils.postPlainBody(url, content, headerMap);
    }

    /**
     * 提交json格式的body请求
     * @param url     请求地址
     * @param content 请求的json格式body
     * @return 响应内容
     */
    public String postJsonBody(String url, String content, Map<String, String> headerMap) {
        return OkHttpUtils.postJsonBody(url, content, headerMap);
    }

    /**
     * 同步阻塞获取文件
     * @param url      请求地址
     * @param filePath 存储文件路径，如果存在目录，需要先创建目录
     */
    public void download(String url, String filePath) {
        OkHttpUtils.download(url, filePath);
    }

    /**
     * 同步阻塞下载文件
     * @param url      下载地址
     * @param callback 回调处理方案
     */
    public void download(String url, OkHttpDownloadCallback callback) {
        OkHttpUtils.download(url, callback);
    }

    /**
     * 异步下载文件，无法立即获取文件
     * @param url      下载路径
     * @param filePath 文件路径
     */
    public void downloadAysn(String url, String filePath) {
        OkHttpUtils.downloadAysn(url, filePath);
    }

    /**
     * 异步下载文件，无法立即获取文件
     * @param url      下载路径
     * @param callback 下载完成后的回调方法
     */
    public void downloadAysn(String url, OkHttpDownloadCallback callback) {
        OkHttpUtils.downloadAysn(url, callback);
    }
}
