/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.httpclient.config;

import com.bxm.component.httpclient.config.HttpClientProperties;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={HttpClientConnectionManager.class})
@EnableConfigurationProperties(value={HttpClientProperties.class})
@AutoConfigureAfter(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
public class HttpClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConfiguration.class);
    private HttpClientProperties httpClientProperties;

    public HttpClientConfiguration(HttpClientProperties httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    private HttpClientConnectionManager httpClientConnectionManager() {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
        poolingHttpClientConnectionManager.setMaxTotal(this.httpClientProperties.getMaxTotal());
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(50);
        return poolingHttpClientConnectionManager;
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestConfig.class})
    public RequestConfig requestConfig() {
        log.info("\u4f7f\u7528\u4e86component-net\u4e2d\u914d\u7f6e\u7684http\u8fde\u63a5\u53c2\u6570");
        return RequestConfig.custom().setConnectTimeout(this.httpClientProperties.getConnectionTimeout()).setConnectionRequestTimeout(this.httpClientProperties.getWaitTimeout()).setSocketTimeout(this.httpClientProperties.getReadTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={CloseableHttpClient.class})
    public CloseableHttpClient httpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this.httpClientConnectionManager()).setDefaultRequestConfig(this.requestConfig());
        return httpClientBuilder.build();
    }
}

