package com.bxm.component.httpclient.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author liujia
 * @date 12/24/20 6:06 PM
 **/
@ConfigurationProperties(prefix = "compnoent.net")
@Data
public class HttpClientProperties {

    /**
     * 连接远程地址时间
     */
    private int connectionTimeout = 5 * 1000;

    /**
     * 等待读取连接超时时间
     */
    private int readTimeout = 5 * 1000;

    /**
     * 等待获取连接池的超时时间
     */
    private int waitTimeout = 500;

    /**
     * 连接池最大连接数量
     */
    private int maxTotal = 500;
}
