package com.bxm.newidea.component.notify.assembly.wechat;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.model.WechatTextDTO;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.google.common.collect.Lists;

import java.util.List;

import static com.bxm.newidea.component.notify.constant.NotifyMessageConstant.Extend.AT_ALL;

/**
 * 微信文本类消息组装
 *
 * @author liujia
 * @date 11/26/21 10:22 AM
 **/
public class WechatTextMessageAssembler implements IMessageAssembler<TextNotifyMessage, String> {

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.WECHAT_GROUP;
    }

    @Override
    public String assembler(TextNotifyMessage message) {
        WechatTextDTO.TextSub textSub = new WechatTextDTO.TextSub();
        textSub.setContent(message.getContent());

        boolean hitAtAll = false;
        if (message.getExtendMap() != null) {
            String atAll = message.getExtendMap().get(AT_ALL);
            if (null != atAll) {
                textSub.setMentioned_mobile_list(new String[]{"@all"});
                hitAtAll = true;
            }
        }

        if (!hitAtAll) {
            List<String> atMobileList = Lists.newArrayList();

            if (null != message.getMainReceiver()) {
                atMobileList.add(message.getMainReceiver());
            }
            if (null != message.getSubReceiver()) {
                atMobileList.addAll(message.getSubReceiver());
            }

            textSub.setMentioned_mobile_list(atMobileList.toArray(new String[]{}));
        }

        WechatTextDTO wechatTextDTO = new WechatTextDTO();
        wechatTextDTO.setText(textSub);

        return JSON.toJSONString(wechatTextDTO);
    }
}
