package com.bxm.newidea.component.notify.channel;

import com.bxm.newidea.component.notify.channel.dingding.DingdingChannel;
import com.bxm.newidea.component.notify.channel.email.EmailChannel;
import com.bxm.newidea.component.notify.channel.wechat.WechatChannel;
import org.springframework.stereotype.Component;

/**
 * 渠道构建者
 *
 * @author liujia
 * @date 11/26/21 9:27 AM
 **/
@Component
public class ChannelBuilder {

    /**
     * 钉钉通知渠道
     *
     * @param webHook 钉钉通知的webhook
     * @return 通知渠道
     */
    public static IChannel dingding(String webHook) {
        DingdingChannel channel = new DingdingChannel();
        channel.setWebHook(webHook);
        return channel;
    }

    /**
     * 企业微信通知渠道
     *
     * @param webHook 企业微信的webhook
     * @return 通知渠道
     */
    public static IChannel wechatGroup(String webHook) {
        WechatChannel channel = new WechatChannel();
        channel.setWebHook(webHook);
        return channel;
    }

    /**
     * 邮件发送渠道
     *
     * @return 通知渠道
     */
    public static IChannel email() {
        return new EmailChannel();
    }
}
