package com.bxm.newidea.component.notify.interceptor;

import com.bxm.newidea.component.notify.enums.NotifyMessageInterceptorTypeEnum;
import com.bxm.newidea.component.notify.message.NotifyMessage;

/**
 * 通知消息的拦截器
 * 在消息推送处理中进行额外逻辑，如：
 * 记录日志
 * 消息累计和合并
 * 告警抑制等
 *
 * @author liujia
 * @date 11/25/21 10:17 PM
 **/
public interface INotifyMessageInterceptor {

    /**
     * 执行拦截处理逻辑
     *
     * @param message 通知消息
     */
    <T extends NotifyMessage> void invoke(T message);

    /**
     * 拦截器类型
     * 可以参考：{@link NotifyMessageInterceptorTypeEnum}
     * @return
     */
    NotifyMessageInterceptorTypeEnum interceptorType();
}
