package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.rule.IRule;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * 基础的通知消息
 *
 * @author liujia
 * @date 11/25/21 9:15 PM
 **/
public abstract class BaseNotifyMessage implements NotifyMessage {

    String title;

    String content;

    String mainReceiver;

    List<String> subReceiver;

    List<IChannel> channelList;

    List<Class<? extends IRule>> ruleList;

    Map<String, String> extendMap;

    BaseNotifyMessage() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getMainReceiver() {
        return this.mainReceiver;
    }

    @Override
    public List<String> getSubReceiver() {
        return this.subReceiver;
    }

    @Override
    public List<IChannel> getChannelList() {
        return this.channelList;
    }

    @Override
    public List<Class<? extends IRule>> getRuleList() {
        return this.ruleList;
    }

    @Override
    public Map<String, String> getExtendMap() {
        return this.extendMap;
    }

    protected static class BaseNotifyMessageBuilder<T extends BaseNotifyMessageBuilder> {
        String title;

        String content;

        String mainReceiver;

        List<String> subReceiverList;

        List<IChannel> channelList;

        List<Class<? extends IRule>> ruleList;

        Map<String, String> extendMap;

        T proxy;

        BaseNotifyMessageBuilder() {
            subReceiverList = Lists.newArrayList();
            channelList = Lists.newArrayList();
            ruleList = Lists.newArrayList();
            extendMap = Maps.newHashMap();
        }

        public T title(String title) {
            this.title = title;
            return proxy;
        }

        public T content(String content) {
            this.content = content;
            return proxy;
        }

        public T mainReceiver(String mainReceiver) {
            this.mainReceiver = mainReceiver;
            return proxy;
        }

        public T addSubReceiver(String subReceiver) {
            subReceiverList.add(subReceiver);
            return proxy;
        }

        public T putExtend(String key, String value) {
            extendMap.put(key, value);
            return proxy;
        }

        /**
         * 绑定消息发送的渠道，可以绑定多个
         *
         * @param channel 渠道信息
         * @return 当前构建者
         */
        public T bindChannel(IChannel channel) {
            channelList.add(channel);
            return proxy;
        }

        /**
         * 绑定过滤规则，可以绑定多个
         *
         * @param ruleClass 处理规则的类型，必须注册到spring上下文
         * @return 当前构建者
         */
        public T bindRule(Class<? extends IRule> ruleClass) {
            ruleList.add(ruleClass);
            return proxy;
        }

        <M extends BaseNotifyMessage> void fillBaseFiled(M message) {
            message.title = this.title;
            message.content = this.content;
            message.channelList = this.channelList;
            message.ruleList = this.ruleList;
            message.mainReceiver = this.mainReceiver;
            message.subReceiver = this.subReceiverList;
            message.extendMap = this.extendMap;
        }
    }
}
