package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.enums.NotifyMessageTypeEnum;

/**
 * html格式消息
 * @author JIY
 * @date 2021/11/30 3:56 下午
 */
public class HtmlNotifyMessage extends BaseNotifyMessage{

    /**
     * 不公开构造函数，防止手工创建改类
     */
    private HtmlNotifyMessage() {

    }

    @Override
    public NotifyMessageTypeEnum getMessageType() {
        return NotifyMessageTypeEnum.HTML;
    }

    public static class HtmlNotifyMessageBuilder extends BaseNotifyMessageBuilder<HtmlNotifyMessage.HtmlNotifyMessageBuilder> {
        HtmlNotifyMessageBuilder() {
            super();
            this.proxy = this;
        }

        public HtmlNotifyMessage build() {
            HtmlNotifyMessage message = new HtmlNotifyMessage();
            fillBaseFiled(message);
            return message;
        }
    }
}
