package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.enums.NotifyMessageTypeEnum;

/**
 * 文本类型的通知消息
 *
 * @author liujia
 * @date 11/25/21 9:13 PM
 **/
public class TextNotifyMessage extends BaseNotifyMessage {

    /**
     * 不公开构造函数，防止手工创建改类
     */
    private TextNotifyMessage() {

    }

    @Override
    public NotifyMessageTypeEnum getMessageType() {
        return NotifyMessageTypeEnum.TEXT;
    }

    public static class TextNotifyMessageBuilder extends BaseNotifyMessageBuilder<TextNotifyMessageBuilder> {
        TextNotifyMessageBuilder() {
            super();
            this.proxy = this;
        }

        public TextNotifyMessage build() {
            TextNotifyMessage message = new TextNotifyMessage();
            fillBaseFiled(message);
            return message;
        }
    }
}
