package com.bxm.newidea.component.notify.assembly.wechat.model;

import lombok.Data;

/**
 * 微信markdown格式参数
 * <p>
 * {
 * "msgtype": "markdown",
 * "markdown": {
 * "getContent": "实时新增用户反馈<font color=\"warning\">132例</font>，请相关同事注意。\n
 * >类型:<font color=\"comment\">用户反馈</font>
 * >普通用户反馈:<font color=\"comment\">117例</font>
 * >VIP用户反馈:<font color=\"comment\">15例</font>"
 * }
 * }
 *
 * @author JIY
 * @date 2021/11/24 18:56
 */
@Data
public class WechatMarkdownDTO {
    private String msgtype = "markdown";

    private MarkdownSub markdown;

    @Data
    public static class MarkdownSub {
        public String content;

        public MarkdownSub(String content) {
            this.content = content;
        }
    }


}
