package com.bxm.newidea.component.notify.rule.impl;

import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import com.bxm.newidea.component.redisson.utils.RateLimiter;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.TimeUnit;

/**
 * 分布式限流规则
 *
 * @author JIY
 * @date 2021/11/29 5:16 下午
 */

@Slf4j
public class DingdingDistributedLimitRule implements IRule {

    private final RateLimiter limiter;

    public DingdingDistributedLimitRule(RateLimiter limiter) {
        this.limiter = limiter;
    }

    @Override
    public boolean accept(NotifyMessage message) {
        try {
            if (limiter.tryAcquire(1L, 0L, TimeUnit.SECONDS)) {
                return true;
            }
        } catch (InterruptedException e) {
            log.error("redis分布式限流异常,{}", e);
        }
        log.info("钉钉消息推送速度已经达到限流");
        return false;
    }
}
