/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.enums.NotifyMessageTypeEnum;
import com.bxm.newidea.component.notify.message.BaseNotifyMessage;
import com.google.common.collect.Lists;
import java.util.List;

public class CardNotifyMessage
extends BaseNotifyMessage {
    private List<SubLink> subLinks;

    private CardNotifyMessage() {
    }

    public List<SubLink> getSubLinks() {
        return this.subLinks;
    }

    @Override
    public NotifyMessageTypeEnum getMessageType() {
        return NotifyMessageTypeEnum.CARD;
    }

    public static class CardNotifyMessageBuilder
    extends BaseNotifyMessage.BaseNotifyMessageBuilder<CardNotifyMessageBuilder> {
        private List<SubLink> subLinks;

        CardNotifyMessageBuilder() {
            this.proxy = this;
            this.subLinks = Lists.newArrayList();
        }

        public CardNotifyMessageBuilder addSubLink(String clickUrl, String backgroundImgUrl) {
            this.subLinks.add(new SubLink(clickUrl, backgroundImgUrl));
            return this;
        }

        public CardNotifyMessageBuilder addSubLink(String title, String clickUrl, String backgroundImgUrl) {
            this.subLinks.add(new SubLink(title, clickUrl, backgroundImgUrl));
            return this;
        }

        public CardNotifyMessageBuilder addSubLink(String title, String description, String clickUrl, String backgroundImgUrl) {
            this.subLinks.add(new SubLink(title, description, clickUrl, backgroundImgUrl));
            return this;
        }

        public CardNotifyMessage build() {
            CardNotifyMessage message = new CardNotifyMessage();
            this.fillBaseFiled(message);
            message.subLinks = this.subLinks;
            return message;
        }
    }

    public static class SubLink {
        private String clickUrl;
        private String backgroundImgUrl;
        private String title;
        private String description;

        SubLink(String clickUrl, String backgroundImgUrl) {
            this.clickUrl = clickUrl;
            this.backgroundImgUrl = backgroundImgUrl;
        }

        SubLink(String title, String clickUrl, String backgroundImgUrl) {
            this.title = title;
            this.clickUrl = clickUrl;
            this.backgroundImgUrl = backgroundImgUrl;
        }

        SubLink(String title, String description, String clickUrl, String backgroundImgUrl) {
            this.clickUrl = clickUrl;
            this.backgroundImgUrl = backgroundImgUrl;
            this.title = title;
            this.description = description;
        }

        public String getClickUrl() {
            return this.clickUrl;
        }

        public String getBackgroundImgUrl() {
            return this.backgroundImgUrl;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setClickUrl(String clickUrl) {
            this.clickUrl = clickUrl;
        }

        public void setBackgroundImgUrl(String backgroundImgUrl) {
            this.backgroundImgUrl = backgroundImgUrl;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubLink)) {
                return false;
            }
            SubLink other = (SubLink)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clickUrl = this.getClickUrl();
            String other$clickUrl = other.getClickUrl();
            if (this$clickUrl == null ? other$clickUrl != null : !this$clickUrl.equals(other$clickUrl)) {
                return false;
            }
            String this$backgroundImgUrl = this.getBackgroundImgUrl();
            String other$backgroundImgUrl = other.getBackgroundImgUrl();
            if (this$backgroundImgUrl == null ? other$backgroundImgUrl != null : !this$backgroundImgUrl.equals(other$backgroundImgUrl)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubLink;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clickUrl = this.getClickUrl();
            result = result * 59 + ($clickUrl == null ? 43 : $clickUrl.hashCode());
            String $backgroundImgUrl = this.getBackgroundImgUrl();
            result = result * 59 + ($backgroundImgUrl == null ? 43 : $backgroundImgUrl.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "CardNotifyMessage.SubLink(clickUrl=" + this.getClickUrl() + ", backgroundImgUrl=" + this.getBackgroundImgUrl() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
        }
    }
}

