package com.bxm.newidea.component.notify.assembly.dingding.model;

import lombok.Data;

/**
 * 钉钉markdown格式参数
 * <p>
 * {
 * "msgtype": "markdown",
 * "markdown": {
 * "getTitle":"杭州天气",
 * "text": "#### 杭州天气 @150XXXXXXXX \n > 9度，西北风1级，空气良89，相对温度73%\n > ![screenshot](https://img.alicdn.com/tfs/TB1NwmBEL9TBuNjy1zbXXXpepXa-2400-1218.png)\n > ###### 10点20分发布 [天气](https://www.dingtalk.com) \n"
 * },
 * "at": {
 * "atMobiles": [
 * "150XXXXXXXX"
 * ],
 * "atUserIds": [
 * "user123"
 * ],
 * "isAtAll": false
 * }
 * }
 *
 * @author JIY
 * @date 2021/11/24 18:56
 */
@Data
public class DingDingMarkdownDTO {
    private String msgtype = "markdown";

    private MarkdownSub markdown;

    private AtSub at;

    @Data
    public static class MarkdownSub {
        public MarkdownSub(String title, String text) {
            this.title = title;
            this.text = text;
        }

        public String title;

        public String text;
    }
}
