package com.bxm.newidea.component.notify.assembly.wechat;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.model.WechatMarkdownDTO;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.MarkdownNotifyMessage;

/**
 * 微信markdown类消息组装
 *
 * @author liujia
 * @date 11/26/21 10:22 AM
 **/
public class WechatMarkdownMessageAssembler implements IMessageAssembler<MarkdownNotifyMessage, String> {

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.WECHAT_GROUP;
    }

    @Override
    public String assembler(MarkdownNotifyMessage message) {
        WechatMarkdownDTO wechatMarkdownDTO = new WechatMarkdownDTO();
        wechatMarkdownDTO.setMarkdown(new WechatMarkdownDTO.MarkdownSub(message.getContent()));
        return JSON.toJSONString(wechatMarkdownDTO);
    }
}
