package com.bxm.newidea.component.notify.config;

import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelAgent;
import com.bxm.newidea.component.notify.interceptor.INotifyMessageInterceptor;
import com.bxm.newidea.component.notify.rule.IRule;
import com.bxm.newidea.component.notify.rule.RuleExecutor;
import com.bxm.newidea.component.notify.rule.impl.DingdingDistributedLimitRule;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.redisson.utils.RateLimiter;
import com.bxm.newidea.component.redisson.utils.RateLimiterFactory;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

import static com.bxm.newidea.component.notify.constant.NotifyMessageConstant.COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN;

/**
 * 构建当前模块需要注册的bean
 *
 * @author liujia
 * @date 11/26/21 11:38 AM
 **/
@Configuration(proxyBeanMethods = false)
public class ComponentNotifyMessageConfiguration {

    @Bean
    public NotifyMessageSender notifyMessageSender(@Qualifier(COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN) Executor executor,
                                                   ChannelAgent channelAgent) {
        return new NotifyMessageSender(executor, channelAgent);
    }

    @Bean(COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN)
    @ConditionalOnMissingBean(name = COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN)
    public Executor notifyMessagePushExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadFactory(new NamedThreadFactory("component-notify-message"));
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(5);
        executor.setQueueCapacity(500);
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        return executor;
    }

    @Bean("dingdingDistributedLimitRule")
    @ConditionalOnClass(RateLimiterFactory.class)
    public DingdingDistributedLimitRule dingdingLimitRule(RateLimiterFactory rateLimiterFactory) {
        KeyGenerator key = DefaultKeyGenerator.build("dingding", "message");
        RateLimiter limiter = rateLimiterFactory.build(key, 0.3D, 20);
        return new DingdingDistributedLimitRule(limiter);
    }

    @Bean
    public ChannelAgent channelAgent(RuleExecutor executor, List<INotifyMessageInterceptor> messageInterceptor) {

        return new ChannelAgent(executor, messageInterceptor);
    }

    @Bean
    public RuleExecutor ruleExecutor(List<IRule> ruleList) {
        return new RuleExecutor(ruleList);
    }
}
