package com.bxm.newidea.component.notify.constant;

import lombok.experimental.UtilityClass;

/**
 * 通知消息模块相关的常量定义
 *
 * @author liujia
 * @date 11/26/21 9:15 AM
 **/
@UtilityClass
public class NotifyMessageConstant {

    /**
     * 消息异步执行的执行器bean名称，支持调用方自己定义来覆盖
     */
    public static final String COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN = "COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN";

    /**
     * 支持的推送平台
     */
    public static class Platform {

        /**
         * 钉钉
         */
        public static final String DINGDING = "dingding";

        /**
         * 企业微信
         */
        public static final String WECHAT_GROUP = "wechat";

        /**
         * 邮件
         */
        public static final String EMAIL = "email";

    }

    /**
     * 消息支持的额外扩展参数
     */
    public static class Extend {
        /**
         * at 所有人，不是所有平台都支持
         */
        public static final String AT_ALL = "@all";
    }
}
