package com.bxm.newidea.component.notify.markdown;

/**
 * markdown格式
 *
 * @author JIY
 * @date 2021/11/29 6:06 下午
 */
public class Markdown {

    private static StringBuilder markdown;


    public static class MarkdownBuilder {

        public MarkdownBuilder() {
            markdown = new StringBuilder();
        }

        /**
         * 设置一级标题
         *
         * @param title
         * @return
         */
        public MarkdownBuilder setTitleLevelOne(String title) {
            markdown.append(" # ");
            markdown.append(title);
            return this;
        }

        /**
         * 设置二级标题
         *
         * @param title
         * @return
         */
        public MarkdownBuilder setTitleLevelTwo(String title) {
            markdown.append(" ## ");
            markdown.append(title);
            return this;
        }

        /**
         * 设置三级标题
         *
         * @param title
         * @return
         */
        public MarkdownBuilder setTitleLevelThree(String title) {
            markdown.append(" ### ");
            markdown.append(title);
            return this;
        }


        /**
         * 设置四级标题
         *
         * @param title
         * @return
         */
        public MarkdownBuilder setTitleLevelFour(String title) {
            markdown.append(" #### ");
            markdown.append(title);
            return this;
        }

        /**
         * 设置五级标题
         *
         * @param title
         * @return
         */
        public MarkdownBuilder setTitleLevelFive(String title) {
            markdown.append(" ##### ");
            markdown.append(title);
            return this;
        }

        /**
         * 设置六级标题
         *
         * @param title
         * @return
         */
        public MarkdownBuilder setTitleLevelSix(String title) {
            markdown.append(" ###### ");
            markdown.append(title);
            return this;
        }

        /**
         * 设置引用  不换行
         *
         * @param quoteContent
         * @return
         */
        public MarkdownBuilder setQuote(String quoteContent) {
            markdown.append(" > ");
            markdown.append(quoteContent);
            return this;
        }

        /**
         * 设置引用  换行
         *
         * @param quoteContent
         * @return
         */
        public MarkdownBuilder setQuoteAndLineFeed(String quoteContent) {
            setQuote(quoteContent);
            setLineFeed();
            return this;
        }

        /**
         * 设置换行
         *
         * @return
         */
        public MarkdownBuilder setLineFeed() {
            markdown.append(" \n ");
            return this;
        }

        /**
         * 设置普通文本
         *
         * @param plainText
         * @return
         */
        public MarkdownBuilder setPlainText(String plainText) {
            markdown.append(" " + plainText);
            return this;
        }

        /**
         * 设置普通文本 换行
         *
         * @param plainText
         * @return
         */
        public MarkdownBuilder setPlainTextAndLineFeed(String plainText) {
            setPlainText(plainText);
            setLineFeed();
            return this;
        }

        /**
         * 设置字体加粗
         *
         * @param bigText
         * @return
         */
        public MarkdownBuilder setBigText(String bigText) {
            markdown.append(" **");
            markdown.append(bigText);
            markdown.append("** ");
            return this;
        }

        /**
         * 设置字体加粗  换行
         *
         * @param bigText
         * @return
         */
        public MarkdownBuilder setBigTextAndLineFeed(String bigText) {
            setBigText(bigText);
            setLineFeed();
            return this;
        }

        /**
         * 设置链接
         *
         * @param linkText 链接文字
         * @param linkUrl  链接url
         * @return
         */
        public MarkdownBuilder setlink(String linkText, String linkUrl) {
            markdown.append(" [");
            markdown.append(linkText);
            markdown.append("]");

            markdown.append("(");
            markdown.append(linkUrl);
            markdown.append(") ");
            return this;
        }

        /**
         * 设置链接  换行
         *
         * @param linkText 链接文字
         * @param linkUrl  链接url
         * @return
         */
        public MarkdownBuilder setlinkAndLineFeed(String linkText, String linkUrl) {
            setlink(linkText, linkUrl);
            setLineFeed();
            return this;
        }

        public String build() {
            return markdown.toString();
        }

    }

}
