package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.enums.NotifyMessageTypeEnum;
import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

/**
 * 卡片消息类型的通知消息
 *
 * @author liujia
 * @date 11/25/21 9:13 PM
 **/
public class CardNotifyMessage extends BaseNotifyMessage {

    /**
     * 不公开构造函数，防止手工创建改类
     */
    private CardNotifyMessage() {

    }

    private List<SubLink> subLinks;

    public List<SubLink> getSubLinks() {
        return subLinks;
    }

    @Override
    public NotifyMessageTypeEnum getMessageType() {
        return NotifyMessageTypeEnum.CARD;
    }

    @Data
    public static class SubLink {
        SubLink(String clickUrl, String backgroundImgUrl) {
            this.clickUrl = clickUrl;
            this.backgroundImgUrl = backgroundImgUrl;
        }

        SubLink(String title, String clickUrl, String backgroundImgUrl) {
            this.title = title;
            this.clickUrl = clickUrl;
            this.backgroundImgUrl = backgroundImgUrl;
        }

        SubLink(String title, String description, String clickUrl, String backgroundImgUrl) {
            this.clickUrl = clickUrl;
            this.backgroundImgUrl = backgroundImgUrl;
            this.title = title;
            this.description = description;
        }

        /**
         * 点击卡片后的跳转地址
         */
        private String clickUrl;

        /**
         * 背景图地址
         */
        private String backgroundImgUrl;

        /**
         * 标题文案
         */
        private String title;

        /**
         * 描述信息
         */
        private String description;
    }

    public static class CardNotifyMessageBuilder extends BaseNotifyMessageBuilder<CardNotifyMessageBuilder> {
        CardNotifyMessageBuilder() {
            super();
            this.proxy = this;
            subLinks = Lists.newArrayList();
        }

        private List<SubLink> subLinks;

        public CardNotifyMessageBuilder addSubLink(String clickUrl, String backgroundImgUrl) {
            subLinks.add(new SubLink(clickUrl, backgroundImgUrl));
            return this;
        }

        public CardNotifyMessageBuilder addSubLink(String title, String clickUrl, String backgroundImgUrl) {
            subLinks.add(new SubLink(title, clickUrl, backgroundImgUrl));
            return this;
        }

        public CardNotifyMessageBuilder addSubLink(String title, String description, String clickUrl, String backgroundImgUrl) {
            subLinks.add(new SubLink(title, description, clickUrl, backgroundImgUrl));
            return this;
        }

        public CardNotifyMessage build() {
            CardNotifyMessage message = new CardNotifyMessage();
            fillBaseFiled(message);

            message.subLinks = this.subLinks;
            return message;
        }
    }
}
