package com.bxm.newidea.component.notify.rule;

import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;

/**
 * 规则执行器
 *
 * @author liujia
 * @date 11/25/21 10:03 PM
 **/
@Slf4j
public class RuleExecutor {

    private Map<Class<? extends IRule>, IRule> ruleMap;

    public RuleExecutor(List<IRule> ruleList) {
        this.ruleMap = Maps.newHashMap();

        for (IRule iRule : ruleList) {
            ruleMap.put(iRule.getClass(), iRule);
        }
    }

    public boolean accept(Class<? extends IRule> ruleClass, NotifyMessage message) {
        IRule iRule = ruleMap.get(ruleClass);

        if (iRule == null) {
            log.error("定义的规则[{}]不存在，请确定是否注册到spring上下文", ruleClass);
            return false;
        }

        return iRule.accept(message);
    }
}
