package com.bxm.newidea.component.notify.rule.impl;

import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import com.google.common.util.concurrent.RateLimiter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * 钉钉限流规则，一分钟内最多发送20条
 *
 * @author liujia
 * @date 11/25/21 9:57 PM
 **/
@Component
@Slf4j
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class DingdingLimitRule implements IRule {

    private RateLimiter limiter = RateLimiter.create(0.3);

    @Override
    public boolean accept(NotifyMessage message) {
        if (limiter.tryAcquire()) {
            return true;
        }
        log.info("钉钉消息推送速度已经达到限流");

        return false;
    }

}
