package com.bxm.newidea.component.notify.assembly.wechat.model;

import lombok.Data;

/**
 * 微信文本格式参数
 * <p>
 * {
 * "msgtype": "text",
 * "text": {
 * "getContent": "广州今日天气：29度，大部分多云，降雨概率：60%",
 * "mentioned_list":["wangqing","@all"],
 * "mentioned_mobile_list":["13800001111","@all"]
 * }
 * }
 *
 * @author JIY
 * @date 2021/11/24 18:56
 */
@Data
public class WechatTextDTO {
    private String msgtype = "text";

    private TextSub text;

    @Data
    public static class TextSub {
        /**
         * 内容
         */
        public String content;

        /**
         * @ userid的列表
         * 命名不规范 微信字段定义
         */
        //public String[] mentioned_list;

        /**
         * @ 手机号列表
         * 命名不规范 微信字段定义
         */
        public String[] mentioned_mobile_list;
    }

}
