package com.bxm.newidea.component.notify.channel.email;

import cn.hutool.extra.mail.MailUtil;
import com.bxm.newidea.component.notify.assembly.MessageAssembler;
import com.bxm.newidea.component.notify.assembly.email.model.EmailDTO;
import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 邮件发送
 *
 * @author JIY
 * @date 2021/11/30 8:34 上午
 */
@Component
@Slf4j
public class EmailChannel implements IChannel {

    @Override
    public <T extends NotifyMessage> boolean publish(T message) {

        EmailDTO dto = MessageAssembler.assembly(this.platform(), message);
        if(null == dto){
            return false;
        }
        MailUtil.send(dto.getTo(), dto.getCcs(), null, dto.getSubject(), dto.getContent(), dto.getIsHtml(), null);
        return true;
    }

    @Override
    public Set<Class<? extends IRule>> bindRules() {
        return null;
    }

    @Override
    public String uniqueKey() {
        return null;
    }

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.EMAIL;
    }


}
