package com.bxm.newidea.component.notify.interceptor;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.enums.NotifyMessageInterceptorTypeEnum;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 日志拦截器
 *  记录日志
 * @author JIY
 * @date 2021/12/1 9:40 上午
 */
@Component
@Slf4j
public class LogNotifyMessageInterceptor implements INotifyMessageInterceptor{

    @Override
    public <T extends NotifyMessage> void invoke(T message) {
        log.info("消息推送日志记录,消息内容为:{}", JSON.toJSONString(message));
    }

    @Override
    public NotifyMessageInterceptorTypeEnum interceptorType() {
        return NotifyMessageInterceptorTypeEnum.BEFORE;
    }
}
