package com.bxm.newidea.component.notify.assembly.wechat;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.model.WechatCardDTO;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.CardNotifyMessage;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 微信卡片类类消息组装
 *
 * @author liujia
 * @date 11/26/21 10:22 AM
 **/
public class WechatCardMessageAssembler implements IMessageAssembler<CardNotifyMessage, String> {

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.WECHAT_GROUP;
    }

    @Override
    public String assembler(CardNotifyMessage message) {
        WechatCardDTO.News news = new WechatCardDTO.News();

        List<WechatCardDTO.Articles> articles = Lists.newArrayList();

        for (CardNotifyMessage.SubLink subLink : message.getSubLinks()) {
            articles.add(new WechatCardDTO.Articles(subLink.getTitle(),
                    subLink.getDescription(),
                    subLink.getClickUrl(),
                    subLink.getBackgroundImgUrl()));
        }

        news.setArticles(articles);

        WechatCardDTO wechatDTO = new WechatCardDTO();
        wechatDTO.setNews(news);

        return JSON.toJSONString(wechatDTO);
    }
}
