package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.enums.NotifyMessageTypeEnum;
import lombok.Data;

import java.util.List;

/**
 * markdown类型的通知消息
 *
 * @author liujia
 * @date 11/25/21 9:13 PM
 **/
public class MarkdownNotifyMessage extends BaseNotifyMessage {

    /**
     * 是否使用markdown模板 默认不使用
     */
    private boolean isUseMarkdownTemplate = false;

    /**
     * markdown子模板内容
     */
    private SubMarkdownContent subMarkdownContents;

    /**
     * 不公开构造函数，防止手工创建改类
     */
    private MarkdownNotifyMessage() {

    }

    public boolean isUseMarkdownTemplate() {
        return isUseMarkdownTemplate;
    }

    public MarkdownNotifyMessage.SubMarkdownContent getSubMarkdownContent() {
        return subMarkdownContents;
    }

    @Data
    public static class SubMarkdownContent {
        SubMarkdownContent(List<String> quoteContent) {
            this.quoteContent = quoteContent;
        }

        SubMarkdownContent(String remark, List<String> quoteContent) {
            this.remark = remark;
            this.quoteContent = quoteContent;
        }

        SubMarkdownContent(String applicationName, String triggerRule, String triggerRuleUrl, String remark, List<String> quoteContent) {
            this.applicationName = applicationName;
            this.triggerRule = triggerRule;
            this.triggerRuleUrl = triggerRuleUrl;
            this.remark = remark;
            this.quoteContent = quoteContent;
        }

        /**
         * 应用名称
         */
        private String applicationName;

        /**
         * 触发规则
         */
        private String triggerRule;

        /**
         * 触发规则url
         */
        private String triggerRuleUrl;

        /**
         * 引用内容 多行引用格式
         */
        private List<String> quoteContent;

        /**
         * 说明
         */
        private String remark;
    }

    @Override
    public NotifyMessageTypeEnum getMessageType() {
        return NotifyMessageTypeEnum.MARK_DOWN;
    }

    public static class MarkdownNotifyMessageBuilder extends BaseNotifyMessageBuilder<MarkdownNotifyMessageBuilder> {

        private SubMarkdownContent subMarkdownContents;

        /**
         * 是否使用markdown模板
         */
        private boolean isUseMarkdownTemplate;

        MarkdownNotifyMessageBuilder() {
            super();
            this.proxy = this;
        }

        public MarkdownNotifyMessageBuilder isUseMarkdownTemplate(boolean isuse) {
            this.isUseMarkdownTemplate = isuse;
            return this;
        }

        public MarkdownNotifyMessageBuilder addSubMarkdownContent(List<String> quoteContent) {
            subMarkdownContents = new SubMarkdownContent(quoteContent);
            return this;
        }

        public MarkdownNotifyMessageBuilder addSubMarkdownContent(String remark, List<String> quoteContent) {
            subMarkdownContents = new SubMarkdownContent(remark, quoteContent);
            return this;
        }

        public MarkdownNotifyMessageBuilder addSubMarkdownContent(String applicationName, String triggerRule, String triggerRuleUrl, String remark, List<String> quoteContent) {
            subMarkdownContents = new SubMarkdownContent(applicationName, triggerRule, triggerRuleUrl, remark, quoteContent);
            return this;
        }

        public MarkdownNotifyMessage build() {
            MarkdownNotifyMessage message = new MarkdownNotifyMessage();
            fillBaseFiled(message);
            return message;
        }


    }
}
