/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.assembly;

import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.dingding.DingdingCardMessageAssembler;
import com.bxm.newidea.component.notify.assembly.dingding.DingdingMarkdownMessageAssembler;
import com.bxm.newidea.component.notify.assembly.dingding.DingdingTextMessageAssembler;
import com.bxm.newidea.component.notify.assembly.email.EmailHtmlMessageAssembler;
import com.bxm.newidea.component.notify.assembly.email.EmailTextMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.WechatCardMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.WechatMarkdownMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.WechatTextMessageAssembler;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.google.common.collect.HashBasedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAssembler {
    private static final Logger log = LoggerFactory.getLogger(MessageAssembler.class);
    private static HashBasedTable<String, Class<?>, IMessageAssembler> registerAssemblerTable = HashBasedTable.create();

    public static void register(IMessageAssembler assembler) {
        Class firstGenericType = ReflectionUtils.getFirstGenericType(assembler.getClass());
        if (null == firstGenericType) {
            log.error("{}\u627e\u4e0d\u5230\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b", (Object)assembler);
            return;
        }
        registerAssemblerTable.put((Object)assembler.platform(), (Object)firstGenericType, (Object)assembler);
    }

    public static <M extends NotifyMessage, R> R assembly(String platform, M message) {
        IMessageAssembler assembler = (IMessageAssembler)registerAssemblerTable.get((Object)platform, message.getClass());
        if (null == assembler) {
            log.info("\u6d88\u606f\u7c7b\u578b[{}]\u548c\u5e73\u53f0[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u5904\u7406\u7c7b\uff0c\u76f4\u63a5\u8fd4\u56de", message.getClass(), (Object)platform);
            return null;
        }
        return assembler.assembler(message);
    }

    static {
        MessageAssembler.register(new DingdingTextMessageAssembler());
        MessageAssembler.register(new DingdingCardMessageAssembler());
        MessageAssembler.register(new DingdingMarkdownMessageAssembler());
        MessageAssembler.register(new WechatTextMessageAssembler());
        MessageAssembler.register(new WechatCardMessageAssembler());
        MessageAssembler.register(new WechatMarkdownMessageAssembler());
        MessageAssembler.register(new EmailTextMessageAssembler());
        MessageAssembler.register(new EmailHtmlMessageAssembler());
    }
}

