/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.markdown;

public class Markdown {
    private static StringBuilder markdown;

    public static class MarkdownBuilder {
        public MarkdownBuilder() {
            markdown = new StringBuilder();
        }

        public MarkdownBuilder setTitleLevelOne(String title) {
            markdown.append(" # ");
            markdown.append(title);
            return this;
        }

        public MarkdownBuilder setTitleLevelTwo(String title) {
            markdown.append(" ## ");
            markdown.append(title);
            return this;
        }

        public MarkdownBuilder setTitleLevelThree(String title) {
            markdown.append(" ### ");
            markdown.append(title);
            return this;
        }

        public MarkdownBuilder setTitleLevelFour(String title) {
            markdown.append(" #### ");
            markdown.append(title);
            return this;
        }

        public MarkdownBuilder setTitleLevelFive(String title) {
            markdown.append(" ##### ");
            markdown.append(title);
            return this;
        }

        public MarkdownBuilder setTitleLevelSix(String title) {
            markdown.append(" ###### ");
            markdown.append(title);
            return this;
        }

        public MarkdownBuilder setQuote(String quoteContent) {
            markdown.append(" > ");
            markdown.append(quoteContent);
            return this;
        }

        public MarkdownBuilder setQuoteAndLineFeed(String quoteContent) {
            this.setQuote(quoteContent);
            this.setLineFeed();
            return this;
        }

        public MarkdownBuilder setLineFeed() {
            markdown.append(" \n ");
            return this;
        }

        public MarkdownBuilder setPlainText(String plainText) {
            markdown.append(" " + plainText);
            return this;
        }

        public MarkdownBuilder setPlainTextAndLineFeed(String plainText) {
            this.setPlainText(plainText);
            this.setLineFeed();
            return this;
        }

        public MarkdownBuilder setBigText(String bigText) {
            markdown.append(" **");
            markdown.append(bigText);
            markdown.append("** ");
            return this;
        }

        public MarkdownBuilder setBigTextAndLineFeed(String bigText) {
            this.setBigText(bigText);
            this.setLineFeed();
            return this;
        }

        public MarkdownBuilder setlink(String linkText, String linkUrl) {
            markdown.append(" [");
            markdown.append(linkText);
            markdown.append("]");
            markdown.append("(");
            markdown.append(linkUrl);
            markdown.append(") ");
            return this;
        }

        public MarkdownBuilder setlinkAndLineFeed(String linkText, String linkUrl) {
            this.setlink(linkText, linkUrl);
            this.setLineFeed();
            return this;
        }

        public String build() {
            return markdown.toString();
        }
    }
}

