/**
 * Copyright (C) 2016 思创数码科技股份有限公司浙江分公司
 * 版权所有
 * 文  件  名：CellValueConvertContext.java
 * 功能概要：
 * 创建日期：2016年5月27日・liuj(liujia1@strongit.com.cn)
 */
package com.bxm.component.office.excel.format;

import com.bxm.component.office.excel.config.ExcelConstant;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import java.util.Map;

/**
 * 用于保存单元格解析时的上下文信息
 * @author liuj(liujia1 @ strongit.com.cn)
 * @version V1.1.1
 */
public class CellValueConvertContext {

    /**
     * 当前操作的工作单
     */
    private Workbook workbook;

    /**
     * 当前操作的sheet
     */
    private Sheet sheet;

    /**
     * 当前操作的行
     */
    private Row row;

    /**
     * 当前操作的列
     */
    private Cell cell;

    /**
     * 当前操作的单元格类型
     */
    private CellTypeEnum cellType;

    /**
     * 扩展参数
     */
    private Map<String, Object> extend;

    public void addExtend(String key, Object value) {
        if (null == extend) {
            extend = Maps.newHashMap();
        }
        if (StringUtils.equals(key, ExcelConstant.EXPORT_HEADER)) {
            SheetHeader header = (SheetHeader) value;
            if (null != header.getExtpend()) {
                extend.putAll(header.getExtpend());
            }
        }
        extend.put(key, value);
    }

    public Object getExtend(String key) {
        if (null == key || null == extend) {
            return null;
        }
        return extend.get(key);
    }

    public Workbook getWorkbook() {
        return workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
        //重置其他参数
        this.sheet = null;
        this.row = null;
        this.cell = null;
        this.cellType = null;
        this.extend = null;
    }

    public Sheet getSheet() {
        return sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
        this.row = null;
        this.cell = null;
        this.cellType = null;
    }

    public Row getRow() {
        return row;
    }

    public void setRow(Row row) {
        this.row = row;
        this.cell = null;
        this.cellType = null;
    }

    public Cell getCell() {
        return cell;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
        this.cellType = CellTypeEnum.STRING;
    }

    public CellTypeEnum getCellType() {
        return cellType;
    }

    public void setCellType(CellTypeEnum cellType) {
        this.cellType = cellType;
    }

    public void setExtend(Map<String, Object> extend) {
        this.extend = extend;
    }

}
