package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.config.ExcelConstant;
import com.bxm.component.office.excel.format.config.CellTypeEnum;
import org.apache.poi.ss.usermodel.Cell;

/**
 * excel导入boolean类型转换器
 * @author pengzz(pengzz @ strongit.com.cn)
 * @version V1.0.0
 */
public class BooleanCellConverter extends AbstractCellConverter {

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.BOOLEAN.equals(cellType);
    }

    @Override
    public void setValue() {
        Object trueLabel = getContext().getExtend(ExcelConstant.BOOLEAN_TRUE_LABEL);
        Object falseLabel = getContext().getExtend(ExcelConstant.BOOLEAN_FALSE_LABEL);
        if (null == trueLabel) {
            trueLabel = "是";
        }
        if (null == falseLabel) {
            falseLabel = "否";
        }
        Object value = getSetValue();
        boolean setValue = false;
        // 除了boolean类型，均认定为false
        if (null != value) {
            if (value.getClass().isAssignableFrom(boolean.class) || value.getClass().isAssignableFrom(Boolean.class)) {
                setValue = (Boolean) value;
            } else {
                logger.warn("转换的字段值不是boolean类型，将被设置为false");
            }
        }
        getCell().setCellValue(setValue ? trueLabel.toString() : falseLabel.toString());
    }

    @Override
    public Object getValue() {
        int cellType = getCellType();

        String cellValue = null;
        if (cellType == Cell.CELL_TYPE_STRING) {
            cellValue = getCell().getStringCellValue();
        }
        // 转换boolean类型时支持自定义的true值标签，可以将与指定值匹配的单元格值转换为false
        Object trueLabel = getContext().getExtend(ExcelConstant.BOOLEAN_TRUE_LABEL);

        return (null != trueLabel && trueLabel.toString().equals(cellValue)) || "on".equalsIgnoreCase(cellValue)
                || "是".equals(cellValue);
    }

    @Override
    public int getOrder() {
        return LOWEST_PRECEDENCE;
    }

}
