/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.parse.impl;

import com.bxm.component.office.excel.parse.impl.AbstractExcelParser;
import com.bxm.component.office.excel.parse.setting.ParseHeader;
import com.bxm.component.office.exception.ParseException;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SimpleExcelParser<T>
extends AbstractExcelParser<T> {
    private Map<String, Integer> headerMap = new HashMap<String, Integer>();
    private int currentRow = 0;
    private int currentCol = 0;

    @Override
    protected List<T> parseSheet() {
        this.currentRow = 0;
        ArrayList result = Lists.newArrayList();
        Iterator rowIterator = this.sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            this.currentRow = row.getRowNum();
            if (this.currentRow < this.setting.getHeaderRow()) continue;
            if (this.currentRow == this.setting.getHeaderRow()) {
                this.parseHeader(row);
                continue;
            }
            result.add(this.parseRow(row));
        }
        return result;
    }

    private void parseHeader(Row row) {
        if (this.setting.isHeaderModel()) {
            this.currentCol = 0;
            Iterator cellIteratro = row.cellIterator();
            while (cellIteratro.hasNext()) {
                Cell cell = (Cell)cellIteratro.next();
                this.getContext().setCell(cell);
                this.getContext().addExtend("CELL_VALUE_CLASS", String.class);
                Object title = this.cellValueManage.getValue();
                this.headerMap.put(null == title ? this.currentCol + "\u672a\u5b9a\u4e49" : title.toString(), this.currentCol);
                ++this.currentCol;
            }
            for (ParseHeader header : this.setting.getHeads()) {
                if (this.headerMap.containsKey(header.getTitle())) continue;
                this.headerMap.put(header.getTitle(), this.currentCol++);
            }
        }
    }

    private T parseRow(Row row) {
        Object obj;
        try {
            obj = this.setting.getEntityClasz().newInstance();
            for (ParseHeader header : this.setting.getHeads()) {
                Field field;
                int index = header.getColIndex();
                if (this.setting.isHeaderModel()) {
                    Integer intIndex = this.headerMap.get(header.getTitle());
                    if (null == intIndex) {
                        this.LOGGER.warn("Excel\u4e2d\u4e0d\u5b58\u5728\u5217\u6807\u9898\u4e3a\uff1a{0}\u7684\u5217", (Object)header.getTitle());
                        continue;
                    }
                    index = intIndex;
                }
                if ((field = this.getField(header.getField())) == null) continue;
                Cell cell = row.getCell(index);
                Object value = null;
                if (null == cell && null != header.getDefaultValue()) {
                    value = header.getDefaultValue().getValue();
                } else if (null != cell) {
                    this.getContext().setCell(row.getCell(index));
                    this.getContext().setCellType(header.getCellType());
                    this.getContext().addExtend("CELL_VALUE_CLASS", field.getType());
                    this.getContext().addExtend("PARSE_HEADER", header);
                    value = this.cellValueManage.getValue();
                }
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, obj, value);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ParseException(e.getMessage());
        }
        return (T)obj;
    }

    private Field getField(String fieldName) {
        Field field = ReflectionUtils.findField(this.setting.getEntityClasz(), (String)fieldName);
        if (field == null) {
            this.LOGGER.warn("[{0}]\u5728[{1}]\u4e2d\u672a\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u62fc\u5199\u662f\u5426\u6b63\u786e", (Object)fieldName, this.setting.getEntityClasz());
        }
        return field;
    }
}

