package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;

/**
 * 功能说明：<br/>
 * 默认转换器，对所有情况均进行处理，但处于最低的优先级
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月3日<br/>
 */
public class DefaultCellConverter extends AbstractCellConverter {

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.STRING.equals(cellType);
    }

    @Override
    public void setValue() {
        Object setValue = getSetValue();
        if (null == setValue) {
            setValue = "";
        }
        getCell().setCellValue(setValue.toString());
    }

    @Override
    public int getOrder() {
        return LOWEST_PRECEDENCE;
    }

    @Override
    public Object getValue() {
        return getCell().getStringCellValue();
    }

}
