package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.newidea.component.tools.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

import java.math.BigDecimal;

/**
 * 功能说明：<br/>
 * 数值类型转换器
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月3日<br/>
 */
public class NumericCellConverter extends AbstractCellConverter {

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.NUMERIC.equals(cellType);
    }

    @Override
    public void setValue() {
        Object value = getSetValue();
        if (null == value) {
            value = "0";
        }
        getCell().setCellType(HSSFCell.CELL_TYPE_NUMERIC);

        CellStyle cellStyle = getCell().getCellStyle();
        if (cellStyle.getAlignment() != HSSFCellStyle.ALIGN_RIGHT) {
            String converterCellStyleKey = NumericCellConverter.class.getSimpleName();
            CellStyle numCellStyle = (CellStyle) getContext().getExtend(converterCellStyleKey);
            if (null == numCellStyle) {
                numCellStyle = getContext().getWorkbook().createCellStyle();
                numCellStyle.cloneStyleFrom(cellStyle);
                numCellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);

                getContext().addExtend(converterCellStyleKey, numCellStyle);
            }

            getCell().setCellStyle(numCellStyle);
        }

        getCell().setCellValue(value.toString());
    }

    @Override
    public Object getValue() {
        int cellType = getCell().getCellType();
        Double value = null;
        if (Cell.CELL_TYPE_NUMERIC == cellType) {
            value = getCell().getNumericCellValue();
        } else if (Cell.CELL_TYPE_STRING == cellType) {
            value = NumberUtils.parseToDouble(getCell().getStringCellValue());
        }
        Class<?> clasz = getValueClass();

        if (null == value) {
            return 0;
        }
        if (BigDecimal.class.equals(clasz)) {
            return new BigDecimal(value);
        } else if (Double.class.equals(clasz) || double.class.equals(clasz)) {
            return value;
        } else if (Float.class.equals(clasz) || float.class.equals(clasz)) {
            return new Float(value);
        } else if (Integer.class.equals(clasz) || int.class.equals(clasz)) {
            return value.intValue();
        } else if (Short.class.equals(clasz) || short.class.equals(clasz)) {
            return value.shortValue();
        } else if (Long.class.equals(clasz) || long.class.equals(clasz)) {
            return value.longValue();
        }
        return value;
    }

}
