package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.newidea.component.tools.DateUtils;
import org.apache.poi.ss.usermodel.Cell;

import java.sql.Timestamp;
import java.util.Date;

/**
 * 功能说明：<br/>
 * 时间戳类型转换器
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月3日<br/>
 */
public class TimestampCellConverter extends AbstractCellConverter {

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.TIMESTAMP.equals(cellType);
    }

    @Override
    public void setValue() {
        Object value = getSetValue();
        if (value instanceof Date) {
            getCell().setCellValue(DateUtils.formatDateTime((Date) value));
        }
    }

    @Override
    public Object getValue() {
        Class<?> clasz = getValueClass();

        int cellType = getCellType();

        Date date = null;
        if (cellType == Cell.CELL_TYPE_STRING) {
            String value = getCell().getStringCellValue();
            date = DateUtils.parse(value);
        } else if (cellType == Cell.CELL_TYPE_NUMERIC) {
            date = getCell().getDateCellValue();
        }

        if (null != date) {
            if (java.sql.Date.class.equals(clasz)) {
                return new java.sql.Date(date.getTime());
            }
            if (Timestamp.class.equals(clasz)) {
                return new Timestamp(date.getTime());
            }
        }

        return date;
    }

}
