/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.component.office.excel.format.impl.AbstractCellConverter;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class TextCellConverter
extends AbstractCellConverter {
    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.TEXT.equals((Object)cellType);
    }

    @Override
    public void setValue() {
        Object value = this.getSetValue();
        if (value == null) {
            value = "";
        }
        CellStyle cellStyle = this.getCell().getCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.getCell().setCellValue(value.toString());
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public Object getValue() {
        CellType cellType = this.getCellType();
        if (CellType.STRING == cellType) {
            return this.getCell().getStringCellValue();
        }
        if (CellType.NUMERIC == cellType) {
            return this.getDoubleCellStringValue();
        }
        return null;
    }
}

