package com.bxm.component.office.excel.format;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import org.springframework.core.Ordered;

/**
 * 功能说明：<br/>
 * excel单元格值设值、取值转换接口
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月3日<br/>
 */
public interface CellValueConverter extends Ordered {

    /**
     * 转换器是否可对对应的单元格类型进行处理
     * @param cellType 单元格类型
     * @return true表示可处理
     */
    boolean isMatch(CellTypeEnum cellType);

    /**
     * 设置转换器对应调度处理器
     * @param manage
     */
    void setCellValueManage(CellValueManage manage);

    /**
     * 进行设值操作
     */
    void setValue();

    /**
     * 取值操作
     * @return 从cell中取出的值
     */
    Object getValue();

}
