package com.bxm.component.office.excel.export.themes;

import com.bxm.component.office.excel.export.themes.impl.ContentCellStyleCreaterImpl;
import com.bxm.component.office.excel.export.themes.impl.HeadCellStyleCreaterImpl;
import com.bxm.component.office.excel.export.themes.impl.TitleCellStyleCreaterImpl;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * 功能说明：<br/>
 * excel导出样式管理工具类<br/>
 * 此类必须配置为原型模式
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月1日<br/>
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ExcelThemesManage {

    private Logger LOGGER = LoggerFactory.getLogger(getClass());

    private CellStyleCreater titleCellStyleCreater = new TitleCellStyleCreaterImpl();

    private CellStyleCreater headCellStyleCreater = new HeadCellStyleCreaterImpl();

    private CellStyleCreater contentCellStyleCreater = new ContentCellStyleCreaterImpl();

    private CellStyle titleStyle;

    private CellStyle headStyle;

    private CellStyle contentStyle;

    private boolean init;

    /**
     * 覆盖标题单元格样式创建器
     * @param titleCellStyleCreater
     */
    public void setTitleCellStyleCreater(CellStyleCreater titleCellStyleCreater) {
        this.titleCellStyleCreater = titleCellStyleCreater;
    }

    /**
     * 覆盖表头单元格样式创建器
     * @param headCellStyleCreater
     */
    public void setHeadCellStyleCreater(CellStyleCreater headCellStyleCreater) {
        this.headCellStyleCreater = headCellStyleCreater;
    }

    /**
     * 覆盖内容单元格样式创建器
     * @param contentCellStyleCreater
     */
    public void setContentCellStyleCreater(CellStyleCreater contentCellStyleCreater) {
        this.contentCellStyleCreater = contentCellStyleCreater;
    }

    /**
     * 初始化样式生成器
     * @param workbook
     */
    public void init(HSSFWorkbook workbook) {
        init = true;
        titleCellStyleCreater.setWorkbook(workbook);
        headCellStyleCreater.setWorkbook(workbook);
        contentCellStyleCreater.setWorkbook(workbook);
    }

    /**
     * 获取Excel标题单元格样式
     * @return 单元格样式
     */
    public CellStyle getTitleStyle() {
        assertInit();
        if (titleStyle == null) {
            titleStyle = titleCellStyleCreater.create();
        }
        return titleStyle;
    }

    /**
     * 获取Excel表头单元格样式
     * @return 单元格样式
     */
    public CellStyle getHeadStyle() {
        assertInit();
        if (headStyle == null) {
            headStyle = headCellStyleCreater.create();
        }
        return headStyle;
    }

    /**
     * 获取Excel主要内容单元格样式
     * @return 单元格样式
     */
    public CellStyle getContentStyle() {
        assertInit();
        if (contentStyle == null) {
            contentStyle = contentCellStyleCreater.create();
        }
        return contentStyle;
    }

    /**
     * 验证是否进行了初始化工作
     */
    private void assertInit() {
        if (!init) {
            LOGGER.error("请调用ExcelThemesManage.init初始化");
        }
    }

}
